/**
 * control view of UI
 * @author sunnyjiang
 * @version 1.1
 */

var view = {};

/*
   disable select for all
 */
view.noselect = function(){
	document.onselectstart = new Function("return false");
	document.ondragstart = new Function("return false");
};
/**
 * set button disabled 
 */
view.setButtonDisabled = function(buttonName) {
	var	button = $('#' + buttonName);
	
	button.data('disabled', 'disabled');
	
	var commonStyle = button.attr('id');

	button.attr('class', commonStyle + '-disabled');
	
	view.cancelButtonPressed(buttonName);

	// set click disabled
	button.unbind('click'); // when cancel html event, use $('#me').removeAttr('onclick');
};

view.isButtonDisabled = function(element) {
	return $(element).data('disabled') == 'disabled';
};

/**
 * set button enabled 
 */
view.setButtonEnabled = function(buttonName) {
	var	button = $('#' + buttonName);
	
	button.removeData('disabled');
	
	var currentStyle = button.attr('class');
	
	// when current is pressed, return, fix bug-when pressed, set enabled, style error
	if(currentStyle.indexOf('-pressed') > -1) {
		return;
	}
	
	var commonStyle = currentStyle.replace('-disabled', '');
	
	button.attr('class', commonStyle);
//	element.removeClass('toolbar-button-disable');
	
	// TODO set click disabled
//	element.unbind('click'); // when cancel html event, use $('#me').removeAttr('onclick');
	
	// recover pressed view
//	if(element.data('pressable') == 'pressable') 
	this.setButtonPressed(buttonName);

	button.unbind('click');
};

/**
 * set button lists pressed style
 */
view.setButtonListPressed = function(buttonNameList) {
	for(var i = 0; i < buttonNameList.length; i++) {
		var buttonName = buttonNameList[i];
		view.setButtonPressed(buttonName);
	}
};

/**
 * when button pressed and release, set view and event
 */
view.setButtonPressed = function(buttonName) {
	var	button = $('#' + buttonName);
	
//	button.attr('pressable', 'pressable');
	
	// return when button disabled
	if(button.data('disabled') == 'disabled')
		return;
	
	var commonStyle = button.attr('class');
	var pressedStyle = commonStyle + '-pressed';
	
//	debug(pressedStyle);
	
	// 鼠标按下
	button.bind("mousedown", function() {
		button.addClass(pressedStyle);
	}).bind("mouseup", function() {
		button.removeClass(pressedStyle);
	});
	
	// TODO 处理
	// 在其他处释放鼠标一样设置样式
//	$(window).bind("mouseup", function() {
//		button.removeClass(pressedStyle);	
//	});	
};

/**
 * 取消按钮可按下的事件
 */
view.cancelButtonPressed = function(elementName) {
	$('#' + elementName).unbind("mousedown").unbind("mouseup");
//	$(window).unbind("mouseup");
};

/**
 * 根据当前tab状态切换go、forward表现
 * 如果可用，setButtonPressed；不可用，取消button pressed事件
 */
view.setBackAndForwardButtonStatus = function() {
	var tab = tabManager.getCurrentTab();
		
	// 如果当前按钮可以后退，设置样式和事件
	if(tab.attr('back') == 'true') {

		view.setButtonEnabled('back-button');

		eventManager.bindBackButton();
	} else {

		view.setButtonDisabled('back-button');

	}
	
	// 如果当前按钮可以前进，设置样式和事件
	if(tab.attr('forward') == 'true') {
		view.setButtonEnabled('forward-button');

		eventManager.bindForwardButton();
	} else {
		
		view.setButtonDisabled('forward-button');

	}	
};

view.disableUndoButtons = function() {
	view.setButtonDisabled('undo-list-button');
	view.setButtonDisabled('undo-button');
};

view.enableUndoButtons = function() {
	// 有撤销列表项目时，启用按钮
	view.setButtonEnabled('undo-list-button');
	view.setButtonEnabled('undo-button');
	
	eventManager.bindUndoButtons();
};

/**
 * 根据当前标签的engine属性切换内核标签显示
 * @param setType: 0或者空时为恢复内核显示，1为切换内核
 */
view.setEngine = function(setType) {
	var currentTab = tabManager.getCurrentTab();
	var engineAttr = currentTab.attr('engine');
	
	// 未设置属性时，视为页面未打开；或者是engineAttr为N，不显示内核，不显示内核图标
	if(!engineAttr || engineAttr == '' || engineAttr == 'N') {
		return;
	}

	var engineIEAttr = 'I';
	var engineWebkitAttr = 'W';
	
	var engineIEId = 'engine-ie-button';
	var engineWebkitId = 'engine-webkit-button';
	
	if(engineAttr == engineWebkitAttr) { // now is webkit
		var newEngineId = setType == 1 ? engineIEId : engineWebkitId;
		var newEngineAttr = setType == 1 ? engineIEAttr : engineWebkitAttr;
	} else { // now is IE
		var newEngineId = setType == 1 ? engineWebkitId : engineIEId;
		var newEngineAttr = setType == 1 ? engineWebkitAttr : engineIEAttr;
	}
	
	addressbar.showEngineButton(newEngineId);
	
	currentTab.attr('engine', newEngineAttr);
};

/**
 * 根据标签id和engine属性切换内核标签显示
 * @param tabId: id of tab, core: I-ie, W-webkit
 */
view.toggleEngine = function(tab, engineAttr) {
	
//	var tab = tabManager.getTab(tabIndex);
	
	tab.attr('engine', engineAttr);
	
	if(tabManager.isCurrentTab(tab)) { // 是当前页面，地址栏状态改变
		
		if(engineAttr == 'N') { // 不显示内核，显示占位符
		}
		else { // 切换到对应内核			
			var engineIEAttr = 'I';
			var engineWebkitAttr = 'W';
			
			var engineIEId = 'engine-ie-button';
			var engineWebkitId = 'engine-webkit-button';
			
			var newEngineId = engineAttr == engineWebkitAttr ? engineWebkitId : engineIEId;
			
			addressbar.showEngineButton(newEngineId);
		}
	}
};

/**
 * init new tab button
 */
view.initNewTabButton = function() {
	var newTabButton = $('#new-tab-button');
	
	newTabButton.mousedown(function() {
		$(this).attr('class', 'new-tab-button-pressed');
	}).click(function() {
		tipManager.hideTooltip();	
		tabManager.addTab();
		browser.extension.builtin.statistics.increase(STATIS_CMD_TAB_NEW_BLANK_PAGE_CLICKED);	//打开新标签页（加号）按钮点击次数上报
	}).mouseup(function() {
		$(this).attr('class', 'new-tab-button');
	});	
	
	// 在其他处释放鼠标一样设置样式
	$(window).bind("mouseup", function() {
		newTabButton.attr('class', 'new-tab-button');
	});	
};

/**
 * init close button pressed
 */
view.setCloseButtonPressed = function(element) {
		var closeButton = $(element);
		
		var commonStyle = closeButton.attr('class');
		var pressedStyle = commonStyle + '-pressed';
		closeButton.addClass(pressedStyle);	
		
		// 在其他处释放鼠标一样设置样式
		$(window).bind("mouseup", function() {
			closeButton.removeClass(pressedStyle);
		});
		
		closeButton.mouseup(function() {
			closeButton.removeClass(pressedStyle);
		});	
};

/**
 * init close button view
 */
view.initCloseButton = function() {
	var tabCloseButtons = $('#tabset .tab-close');
	
	tabCloseButtons.mousedown(function() {
		$(this).attr('class', 'tab-close-pressed');	
		
		// 在其他处释放鼠标一样设置样式
		$(window).bind("mouseup", function() {
			$(this).attr('class', 'tab-close');
		});
	}).mouseup(function() {
		$(this).attr('class', 'tab-close');
	});	
};

/**
 * 隐藏button的显示，用于截屏按钮和清除痕迹按钮
 */
view.hideButton = function(buttonName) {
	$('#' + buttonName).hide();
	
	layout.adjustAddressInput();
};

/**
 * 显示button，用于截屏按钮和清除痕迹按钮
 */
view.showButton = function(buttonName) {
	$('#' + buttonName).show();
	
	layout.adjustAddressInput();
};

/**
 * 获取屏幕宽度
 */
view.getScreeWidth = function() {
	return window.screen.width;
};

/**
 * 获取屏幕高
 */
view.getScreeHeight = function() {
	return window.screen.height;
};

/**
 * 鼠标在边界时改变样式
 */
view.initBorderCursor = function() {
	try {
		$(document.body).bind('mousemove', function() {
			var windowHeight = $(window).height();
			var windowWidth = $(window).width();
			var borderWidth = view.getSkinBorderWidth();		
			
			var dragButton = $('#drag-button');
			var dragButtonWidth = dragButton.width();	
			
			// 小于min-width或者min-height时不处理		
			var minWindowSize = layout.getMinSize();
	
			if(windowHeight <= minWindowSize.height || windowWidth < minWindowSize.width) {
				return;
			}
			
			// 左边样式
			if(event.pageX <= borderWidth && event.pageY >= windowHeight - borderWidth) // 左下角
				$(document.body).css('cursor', 'sw-resize');
			else if(event.pageY >= windowHeight - borderWidth - dragButtonWidth && event.pageX >= windowWidth - borderWidth - dragButtonWidth) // 右下角
				$(document.body).css('cursor', 'se-resize');
			else if(event.pageY <= borderWidth && event.pageX <= borderWidth) // 左上角
				$(document.body).css('cursor', 'nw-resize');
			else if(event.pageY <= borderWidth && event.pageX >= windowWidth - borderWidth) // 右上角
				$(document.body).css('cursor', 'ne-resize');
			else if(event.pageX <= borderWidth) // 左边样式
				$(document.body).css('cursor', 'w-resize');	
			else if(event.pageY <= document.getElementById("main").offsetTop && event.target.parentNode.parentNode.id != 'head-right-button-box') // 上边样式
				$(document.body).css('cursor', 'n-resize');	
			else if(event.pageY <= borderWidth - 2) // 右上方button box样式
				$(document.body).css('cursor', 'n-resize');		
			else if(event.pageX >= windowWidth - borderWidth) // 右边样式
				$(document.body).css('cursor', 'e-resize');	
			else if(event.pageY >= windowHeight - borderWidth) // 下边样式
				$(document.body).css('cursor', 's-resize');
			else
				$(document.body).css('cursor', 'default');
		});
	} catch(e) {
		//alert(e.message);
	}
};

/**
 * 鼠标切换皮肤
 */
view.toggleSkin = function() {
	if(/newSkin/.test(location.href)) {
		location.href = '../index.html';
	} else {
		location.href = 'newSkin/index.html';
	}
};


view._daPosition = 0;
view._timeOutIdle = null;
view._isMaximized = false;

/**
 * 显示logo登录动画
 */
view.showLogoAnimate = function() {
	$('#logo-menu').hide();
	$('#logon-menu').hide();
	$('#logo-animate').show();
	
	view._controlLogoAnimate();
};

/**
 * 控制动画图片的显示，被反复调用
 */
view._controlLogoAnimate = function() {
	view._controlLogoImg();
};

/**
 * 内部方法，控制动画每张图片显示
 */
view._controlLogoImg = function() {
	var logoAnimateList = $('#logo-menu').is('.logo-menu-min') ? logoSmallAnimateList : logoBigAnimateList;
	
	view._daPosition = view._daPosition == logoBigAnimateList.length - 1 ? 0 : ++view._daPosition;
	
	$('#logo-animate-image').attr('src', logoBigAnimateList[view._daPosition]);

	view._timeOutIdle = setTimeout("view._controlLogoAnimate()", 100);
};

/**
 * 显示登录后的头像
 */
view.showLogonAvatar = function(avatarUrl) {
	clearTimeout(view._timeOutIdle);
	
	if(avatarUrl) {
		$('#logon-menu-image').attr('src', avatarUrl).fadeIn(600);
		//$('#logon-menu-image').attr('src', avatarUrl).show();
	}
	$('#logo-menu').hide();
	$('#logon-menu').show();
	$('#logo-animate').hide();
};

/**
 * 显示登录前的图标
 */
view.initLogoMenu = function() {
	$('#logon-menu-image').fadeOut(600); // 这里去掉了 src=""
	$('#logo-menu').show();
	$('#logon-menu').hide();
	$('#logo-animate').hide();
};

/**
 * 设置最大化最小化时的页面布局
 */
view.toggleMaxAndMinView = function(isMaximized) {
    // 若状态未改变，则直接返回
    if (this._isMaximized === isMaximized) {
        return;
    }

	view._isMaximized = isMaximized;
	view.toggleMaxAndRestoreButton(isMaximized);
	
	// 需要设置的元素列表
/*	var elementList = ['body', 'head-wrapper', 'tab-wrapper-right', 'logo-menu', 'logo-animate', 
	                   'logon-menu', 'tab-wrapper', 'page-wrapper', 'statusbar-box'];*/
	var elementList = ['body-wrapper','main', 'head-wrapper','head-top-box-wrapper', 'tab-wrapper-right', 'logo-menu', 'logo-animate', 
	                   'logon-menu', 'tab-wrapper', 'head-middle-box', 'head-middle-box-inner', 'page-wrapper', 'statusbar-box'];
	if(isMaximized ) { // 最大化时

        // 隐藏右下角可以改变窗口大小的箭头
        $('#drag-button').hide();

//		var oldHeadHeight = $('#head-wrapper').height();
		// 移动tab-wrapper-right
		$('#head-right-button-box').append($('#tab-wrapper-right'));
		
		// 设置样式
		for(var i = 0; i < elementList.length; i++) {
			var elementId = elementList[i];
			$('#' + elementId).removeClass(elementId).addClass(elementId + '-min');
		}
		
		// 设置按下样式
		view.setButtonPressed('logo-menu');
		view.setButtonPressed('logon-menu');

//		var headHeight = $('#head-wrapper').height();
//		$('#page-box').height($('#page-box').height() - headHeight); // 计算page-box大小，否则会将页面撑开		
		
		layout.resize();

		$(document.body).css('cursor', 'default'); // 防止在max按钮上鼠标变成resize
		$(document.body).unbind('mousemove'); // 在边框时不变化样式		

	} else if(!isMaximized ) {

        // 显示右下角可以改变窗口大小的箭头
        $('#drag-button').show();

//		var oldHeadHeight = $('#head-wrapper').height();
		// 移动tab-wrapper-right
		$('#tab-wrapper-right').insertAfter('#close-button');
		
		// 设置样式
		for(var i = 0; i < elementList.length; i++) {
			var elementId = elementList[i];
			$('#' + elementId).removeClass(elementId + '-min').addClass(elementId);
		}		
		
		// 设置按下样式
		view.setButtonPressed('logo-menu');
		view.setButtonPressed('logon-menu');
		
//		var headHeight = $('#head-wrapper').height();
//		$('#page-box').height($('#page-box').height() - headHeight); // 计算page-box大小，否则会将页面撑开
		try{
			layout.resize();
		}catch(err){
		}
		
		view.initBorderCursor(); // 初始化边框的鼠标样式
	}
//	layout.resize(); // 解决关闭tab后最大最小切换的问题
};

/**
 * 在最大化和恢复按钮间切换
 */
view.toggleMaxAndRestoreButton = function(isMaximized) {
	if(isMaximized) {
		$('#max-button').hide();
		$('#restore-button').show();
	} else {
		$('#restore-button').hide();
		$('#max-button').show();
	}
};

/**
 * 在停止和刷新按钮减切换
 */
view.toggleStopAndRefreshButton = function() {
	$('#stop-button, #refresh-button').toggle();
};

/**
 * 设置Aero效果
 */
view.toggleAero = function() {
	if($(document.body).is('.body-aero')) {
		$('#head-wrapper').removeClass('head-wrapper-aero');
		$(document.body).removeClass('body-aero');
	} else {
		$('#head-wrapper').addClass('head-wrapper-aero');
		$(document.body).addClass('body-aero');		
	}
};

/**
 * 淡入效果
 */
view.fadeButtonIn = function() {
    $('.hover', this).stop().animate({
        'opacity': 1
    }, 150);
};

/**
 * 淡出效果
 */
view.fadeButtonOut = function() {
    $('.hover', this).stop().animate({
        'opacity': 0
    }, 150);
};

/**
 * 得到边框的大小
 */
view.getSkinBorderWidth = function() {
	// border以page-wrapper的两边为准
	return $('#page-box').offset().left;
};

/**
 * 判断是否aero，设置背景
 */
view.setAero = function() {
	if(browser.os.windows.isDwmCompositionEnabled()) { // aero
		// background transparent
		$('body').addClass('aero');
	} else {
		$('body').removeClass('aero');
	}
};

/**
 * Preload the scrollbar images
 */
view.preloadImage = function(images) {
	for(var i = 0; i < images.length; i++) {
		var image = images[i];
		(new Image()).src = image;
	}
};

/**
 * 针对border + box shadow提供同一解决方案
 */
view.getSize = function(elementName) {
	var element = typeof elementName == 'string' ? $('#' + elementName) : elementName; // 可以直接传递jquery对象
	
	var innerHeight = element.outerHeight();
	var innerWidth = element.outerWidth();

	// 计算box shadow的高度
	var elementShadow = element.css('-webkit-box-shadow');

	var regex = /(\dpx)\s(\dpx)\s(\dpx)/;
	
	var elementShadowOffsetX = elementShadowOffsetY = elementSize = 0;
	
	if(regex.test(elementShadow)) {
		elementShadowOffsetX = utils.fromPx2Int(RegExp["$1"]);
		elementShadowOffsetY = utils.fromPx2Int(RegExp["$2"]);	
		elementSize = utils.fromPx2Int(RegExp["$3"]);
	}
	
	return {width: innerWidth + elementShadowOffsetX + elementSize, height: innerHeight + elementShadowOffsetY + elementSize};
};

/**
 * 去掉border的offset
 */
view.getInnerOffset = function(elementName) {
	var element = typeof elementName == 'string' ? $('#' + elementName) : elementName; // 可以直接传递jquery对象
	
	var offsetLeft = element.offset().left;
	var offsetTop = element.offset().top;

	var borderWidth = view.getBorderWidth(elementName);
	var borderLeft = borderWidth.left;
	var borderTop = borderWidth.top;
	
	return {left: offsetLeft + borderLeft, top: offsetTop + borderTop};
	// 计算box shadow的高度
};

/**
 * 获取border的宽度
 */
view.getBorderWidth = function(elementName) {
	var element = (typeof elementName == 'string') ? $('#' + elementName) : elementName; // 可以直接传递jquery对象
	
	var borderLeft = utils.fromPx2Int(element.css('border-left-width'));
	var borderTop = utils.fromPx2Int(element.css('border-top-width'));
	var borderBottom = utils.fromPx2Int(element.css('border-bottom-width'));
	var borderRight = utils.fromPx2Int(element.css('border-right-width'));
	
	return {'left': borderLeft, 'top': borderTop, 'bottom': borderBottom, 'right': borderRight};
};

/**
 * 获得button左下角坐标
 */
view.getMenuLeftBottom = function(button) {
	var buttonLeft = button.offset().left;
	var buttonBottom = button.offset().top + button.outerHeight();
	
	return {left: buttonLeft, top: buttonBottom};
};

/**
 * 焦点管理
 */
view.currentFocus = null;

/**
 * 设置焦点
 * @param url page的url
 * @param type 是否是点击tab进入，如果是，焦点已在皮肤上，无需再调用浏览器api
 */
view.setFocus = function(url, element) {
	if(url == DEFAULT_SITE_URL || url == BLANK_PAGE_URL || url == "") { // 如果传入url为qb:home，为打开默认页面，设置焦点到地址栏；about blank、或者新首页("")也应该设置焦点到地址栏
		view.setFocus2Skin();
		addressbar.selectAllInput();
	} else { // 否则焦点到页面
		view.setFocus2Web();
	} 
};

/**
 * 设置焦点到皮肤上
 * @param type 是否要通知浏览器 
 */
view.setFocus2Skin = function(element) {
	view.currentFocus = 'skin';
//	$('#favbar-box').html('1');
//	setTimeout("$('#address-input').focus()", 260);
	if (element !== undefined) {
		if(element.id == 'address-input' || element.id == 'address-list-button') { // 地址栏
			addressbar.focus();
		}
		
		if(element.id.substr(0, 3) != "tab") { // 此时不是通过点击tab进入
			browser.skin.window.setFocus();
		}
	} else {
		addressbar.focus();
		browser.skin.window.setFocus();
	}
//	addressbar.selectAllInput();

	
};

/**
 * 设置焦点到页面上
 */
view.setFocus2Web = function() {
//	$('#favbar-box').html('2');
	view.currentFocus = 'page';

	browser.skin.window.setFocusToWeb();
};

/**
 * 设置按钮文字
 */

view.setButtonText = function(buttonGuid, text) {
	// TODO 和listener、eventManager里的对应关系合并
	var buttonMap = {
		'{D21B044A-3FDF-4241-865C-5692771BED80}': 'zoom-box',
		'{87281D86-2185-4656-BF0D-C88478545F4C}': 'screen-box'			
	};			
	
	var buttonId = buttonMap[buttonGuid];
	
	if(buttonId) {
		$('#' + buttonId + ' .button-text').html(text); // 仅设定类标识为button-text的元素
	}
};

/**
 *  设置状态栏显示页面状态 
 */
view.setPageStatus = function(tabId, status, url) {
	var tab = tabManager.getTabFromId(tabId);
	tab.data('status', status);
	tab.data('url', url);
	
	if(tabId == tabManager.getCurrentTabId()) { // 如果是当前tab，直接显示
		view.showPageStatus(tabId);
	}
};

/**
 * 显示状态栏状态
 */
view.showPageStatus = function(tabId) {

	var tab = tabManager.getTabFromId(tabId);
	var status = tab.data('status');
	var url = tab.data('url');
	
	if(url.length >= 26) { // 只取前26位的字符
		url = url.substr(0, 26) + '...';
	}
	
	if(status) {
		var statusMap = {
			'loadbefore': '正在发送请求',
			'loading': '正在等待%host%返回数据',
			'loaderror': '网页有错误',
			'loadend': '完成'		
		};		
		
		var statusbarStatusImage = $('#statusbar-status-image');
		if(statusbarStatusImage.is('.updating') || statusbarStatusImage.is('.updateerror')) { // 正在升级时不显示
			return;
		}
		
		statusbarStatusImage.attr('class', 'statusbar-status-image').addClass(status);
		
		var text = statusMap[status];
		if(status == 'loading') {
			text = text.replace('%host%', url);
		}
			
		view.setStatusText(text);		
	}
};

/**
 * 根据版本升级进度在状态栏显示
 */
view.setUpdateStatus = function(errorText, precent) {
	var statusbarStatusImage = $('#statusbar-status-image');
	
	if(parseInt(precent) == 100) {
		statusbarStatusImage.attr('class', 'statusbar-status-image');
		view.setStatusText('安装成功！');
		return;
	}
	
	if(errorText) { // 升级错误时
	/*
		if(!statusbarStatusImage.is('.updateerror')) {
			statusbarStatusImage.attr('class', 'statusbar-status-image').addClass('updateerror');	
		}
	*/		
	} else { // 升级正常时
		if(!statusbarStatusImage.is('.updating')) {
			statusbarStatusImage.attr('class', 'statusbar-status-image').addClass('updating').addClass('loading-animate');	
		}		
	}
	
	var text = errorText ? " " : '<a href="#" id="status-update">正在安装更新...  ' + precent + '%</a>';
	view.setStatusText(text);	
	
	// 点击弹出升级进度窗口
	$('#status-update').click(function() {
		browser.skin.buttonClicked('{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}', this);
	});
};

/**
 * 设置状态栏显示文字
 */
view.setStatusUrl = function(url) {	
	var statusbarStatusImage = $('#statusbar-status-image');
	if(statusbarStatusImage.is('.updating') || statusbarStatusImage.is('.updateerror')) { // 正在升级时不显示
		return;
	}
	
	view.setStatusText(url);
};

/**
 * 设置状态栏显示文字
 */
view.setStatusText = function(text) {	
	$('#statusbar-status-text').html(text);	
};

view.toggleDownloadbar = function() {
//	$('#downloadbar').animate({height: 0}, 150);
	
//	$('#page-box').animate({height: $('#page-box').height + 38}, 150);
	
//	layout.resize();
	$('#downloadbar').toggle();
	layout.resize();
};

/*
  登录动画
*/
view.loadtimer = -1;
view.startLogonAnimate = function(){
	view.gotoAnimateMode();
	$("#logon-menu-image").hide();
	var aim = $('#logon-loading');
	aim.show();
	aim.data('cnt',0);
	if (-1 != view.loadtimer){
		clearInterval(view.loadtimer);
	}

	view.loadtimer = setInterval(function(){
		var imgpath = "images/logomenu/logoAnimate/loading/loading_";	
		var cnt = aim.data('cnt');
		cnt%=69;
		var filename = ("00000"+cnt);
		var len = filename.length;
		filename = len>5?filename.substr(len-5,5):filename;
		imgpath+=filename+".png";
	//alert(imgpath);
		aim.attr('src',imgpath);
		cnt++;
		aim.data('cnt',cnt);
	},40);
	
	/*
	view.loadtimer = setInterval(function(){
			$(".hover","#logo-menu").animate({'opacity':0},900).
					animate({'opacity':1},700).
					animate({'opacity':1},200);
			//console.info(new Date());
	},(900+700+200));
	*/
};
view.gotoAnimateMode = function(){
		$('#logo-menu').hide();
		$('#logon-menu').show();
		$('#logo-animate').hide();
};
view.stopLogonAnimate = function(){
	 $('#logon-loading').fadeOut(600,function(){
	 		clearInterval(view.loadtimer);
	 });
/*
	$('#logon-loading').hide();
	clearInterval(view.loadtimer);
*/
};
view.loadApptimer = -1;

view.startAppAnimate = function(){
	$("#appbox-event-wrapper").css("z-index","5").
																css("background"," url(images/appBox/appbox_loading_bkg.png) center center no-repeat ").
																css("background-size","100% 100%");
	var aim = $('#appbox-center');
	aim.show();
	aim.data('cnt',0);
	if (-1 != view.loadApptimer){
		clearInterval(view.loadApptimer);
	}
	view.loadApptimer = setInterval(function(){
		var imgpath = "images/appBox/animation/appbox_loading_";	
		var cnt = aim.data('cnt');
		cnt%=12;
		imgpath+=(cnt+1)+".png";
	//alert(imgpath);
		aim.attr('src',imgpath);
		cnt++;
		aim.data('cnt',cnt);
	},100);																
};
view.stopAppAnimate = function(){
	$("#appbox-event-wrapper").css("z-index","-1").css("background","transparent");
	clearInterval(view.loadApptimer);
	$('#appbox-center').attr('src',"").hide();	
}

view.connfailed = function(){
		try{
			qqbrowser.log.info("in view ");
		}catch(err){
		}
		/*
		var image = $("#logon-menu-image")[0];
		var base64 = view.mkGray(image);
		$("#logon-menu-image").attr("src",base64);
		*/
		//$("#logon-menu-image").attr("src","images/confirm/fail.png");
}
view.mkGray = function(img){
		try{
		var canvas = document.createElement("canvas");
		canvas.height=img.height;
		canvas.width = img.width;
		var ctx = canvas.getContext("2d");			
		ctx.drawImage(img,0,0,img.width, img.height);
		var data = ctx.getImageData(0,0,img.width,img.height);
		for (var i =0; i<data.height;i++){
			for (var j=0;j<data.width;j++){
				var ind = (i*data.width+j)*4;
				var mid = (data.data[ind]+data.data[ind+1]+data.data[ind+2])/3;
				data.data[ind] = data.data[ind+1] = data.data[ind+2] = mid;
			}
		}
		ctx.putImageData(data,0,0);
	}catch(err){
		qqbrowser.log.info(err.message);
	}
		try{
			qqbrowser.log.info("in mk gray");
		}catch(err){
		}
		var ret = canvas.toDataURL();
		try{
			qqbrowser.log.info("mkgray "+ret);
		}catch(err){
		}
		return ret;
};

view.drawNumber = function(canvas,num){
				canvas.height = canvas.clientHeight;
				canvas.width = canvas.clientWidth;
        var ctx = canvas.getContext("2d");          
        ctx.font = "10px sans-serif bold";
        ctx.textAlign="cneter";
        ctx.textBaseline="middle";
        var y = canvas.height/2;
        var x = canvas.width/2;
        var txt = ctx.measureText(num);
        x-=txt.width/2;
        txt.height = 10;
        ctx.beginPath();
        ctx.fillStyle = "transparent";
        ctx.fillRect(0,0,canvas.width,canvas.height);
        
        ctx.fillStyle = "hsl(23, 100%, 57%)";
        ctx.strokeStyle="hsl(23, 100%, 57%)";
        ctx.lineWidth = 2;  
        var center = {
            x:canvas.width/2,
            y:canvas.height/2,
            r:(Math.max(txt.width,txt.height)+2)/2,
        };
        ctx.arc(center.x, center.y, center.r, 0, Math.PI*2,false);
        
        ctx.fill();
        //ctx.stroke();
        ctx.fillStyle='hsl(205, 55%, 50%)';
        ctx.fillText(num,x,y);
        /*
        var data = canvas.toDataURL();
				return data;
				*/
}
